function Hero() {
    try {
        const appPreviewImages = [
            "https://app.trickle.so/storage/public/images/usr_0edf4f9ea0000001/50bc811c-1402-4141-8ecf-bd986a1f92e8.jpeg",
            "https://app.trickle.so/storage/public/images/usr_0edf4f9ea0000001/3a858f37-2d77-46ad-9e68-e79ba0bd612f.jpeg",
            "https://app.trickle.so/storage/public/images/usr_0edf4f9ea0000001/9258602b-aa6c-4306-b482-c39838fd4a2b.jpeg",
            "https://app.trickle.so/storage/public/images/usr_0edf4f9ea0000001/45f29f99-2bcf-4485-b94a-daae7aed3cbc.jpeg"
        ];

        return (
            <section data-name="hero" className="hero-section min-h-screen pt-24 pb-12">
                <div className="container mx-auto px-6">
                    <div className="flex flex-col lg:flex-row items-center justify-between">
                        <div data-name="hero-content" className="lg:w-1/2 text-center lg:text-left mb-12 lg:mb-0">
                            <h1 className="text-4xl md:text-6xl font-bold mb-6">
                                Stream <span className="gradient-text">Premium Content</span> Anytime, Anywhere
                            </h1>
                            <p className="text-gray-400 text-lg mb-8">
                                Experience the ultimate streaming with WatchZone. Get access to thousands of movies, TV shows, and exclusive content. Start your entertainment journey today!
                            </p>
                            <div data-name="download-badges" className="flex flex-col sm:flex-row items-center justify-center lg:justify-start space-y-4 sm:space-y-0 sm:space-x-4">
                                <a href="https://techcodebreaker.xyz" target="_blank" rel="noopener noreferrer" className="download-badge pulse-animation">
                                    <img 
                                        src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png" 
                                        alt="Get it on Google Play" 
                                        className="h-16"
                                    />
                                </a>
                            </div>
                        </div>
                        <div data-name="hero-images" className="lg:w-1/2 grid grid-cols-4 gap-4">
                            {appPreviewImages.map((image, index) => (
                                <div key={index} className="hover-scale">
                                    <img 
                                        src={image}
                                        alt={`WatchZone App Preview ${index + 1}`}
                                        className="hero-image w-full rounded-2xl shadow-lg"
                                    />
                                </div>
                            ))}
                        </div>
                    </div>
                </div>
            </section>
        );
    } catch (error) {
        console.error('Hero section error:', error);
        reportError(error);
        return null;
    }
}
