function Footer() {
    try {
        return (
            <footer data-name="footer" className="bg-slate-900 py-12">
                <div className="container mx-auto px-6">
                    <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
                        <div data-name="footer-brand">
                            <div className="flex items-center mb-4">
                                <i className="fas fa-play-circle text-2xl gradient-text mr-2"></i>
                                <span className="text-xl font-bold gradient-text">WatchZone</span>
                            </div>
                            <p className="text-gray-400">Your premium entertainment companion</p>
                        </div>
                        <div data-name="footer-links">
                            <h3 className="text-lg font-semibold mb-4">Quick Links</h3>
                            <ul className="space-y-2">
                                <li><a href="#features" className="text-gray-400 hover:text-white">Features</a></li>
                                <li><a href="#download" className="text-gray-400 hover:text-white">Download</a></li>
                                <li><a href="https://techcodebreaker.xyz" target="_blank" rel="noopener noreferrer" className="text-gray-400 hover:text-white">Visit Website</a></li>
                            </ul>
                        </div>
                        <div data-name="footer-contact">
                            <h3 className="text-lg font-semibold mb-4">Contact Us</h3>
                            <ul className="space-y-2">
                                <li className="text-gray-400">
                                    <i className="fas fa-envelope mr-2"></i>
                                    support@watchzone.com
                                </li>
                                <li className="text-gray-400">
                                    <i className="fas fa-phone mr-2"></i>
                                    +91 1234567890
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div className="border-t border-gray-800 mt-8 pt-8 text-center">
                        <p className="text-gray-400">© 2024 WatchZone. All rights reserved.</p>
                    </div>
                </div>
            </footer>
        );
    } catch (error) {
        console.error('Footer error:', error);
        reportError(error);
        return null;
    }
}
