function Features() {
    try {
        const features = [
            {
                icon: "fa-film",
                title: "Premium Content",
                description: "Access exclusive movies and shows from top studios worldwide"
            },
            {
                icon: "fa-cloud-download-alt",
                title: "Offline Mode",
                description: "Download your favorite content to watch without internet"
            },
            {
                icon: "fa-mobile-alt",
                title: "Multi-Device",
                description: "Seamlessly switch between devices while watching"
            },
            {
                icon: "fa-closed-captioning",
                title: "Multi-Language",
                description: "Enjoy content in your preferred language with subtitles"
            }
        ];

        return (
            <section data-name="features" id="features" className="py-20">
                <div className="container mx-auto px-6">
                    <h2 className="text-3xl md:text-4xl font-bold text-center mb-12">
                        Why Choose <span className="gradient-text">WatchZone</span>
                    </h2>
                    <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                        {features.map((feature, index) => (
                            <div key={index} data-name="feature-card" 
                                 className="feature-card glass-effect p-6 rounded-xl text-center hover-scale">
                                <i className={`fas ${feature.icon} text-4xl feature-icon mb-4`}></i>
                                <h3 className="text-xl font-semibold mb-3">{feature.title}</h3>
                                <p className="text-gray-400">{feature.description}</p>
                            </div>
                        ))}
                    </div>
                </div>
            </section>
        );
    } catch (error) {
        console.error('Features section error:', error);
        reportError(error);
        return null;
    }
}
