export interface Channel {
  title: string;
  url: string;
}

export async function parseM3UFile(url: string): Promise<Channel[]> {
  try {
    const response = await fetch(url);
    const text = await response.text();
    const lines = text.split('\n');
    const channels: Channel[] = [];
    
    let currentTitle = '';
    
    for (let i = 0; i < lines.length; i++) {
      const line = lines[i].trim();
      
      if (line.startsWith('#EXTINF:')) {
        const titleMatch = line.match(/,(.+)$/);
        currentTitle = titleMatch ? titleMatch[1] : 'Unnamed Channel';
      } else if (line.startsWith('http')) {
        channels.push({
          title: currentTitle,
          url: line
        });
      }
    }
    
    return channels;
  } catch (error) {
    console.error('Failed to parse M3U file:', error);
    throw new Error('Failed to load playlist');
  }
}