import React from 'react';
import { Play, Pause, Volume2, VolumeX, Maximize, RefreshCcw } from 'lucide-react';

interface VideoControlsProps {
  isPlaying: boolean;
  isMuted: boolean;
  isLoading: boolean;
  onPlayPause: () => void;
  onMuteToggle: () => void;
  onFullscreen: () => void;
  onRefresh: () => void;
}

const VideoControls: React.FC<VideoControlsProps> = ({
  isPlaying,
  isMuted,
  isLoading,
  onPlayPause,
  onMuteToggle,
  onFullscreen,
  onRefresh,
}) => {
  return (
    <div className="absolute bottom-0 left-0 right-0 p-3 sm:p-4 bg-gradient-to-t from-black/70 to-transparent">
      <div className="flex items-center justify-between text-white">
        <div className="flex items-center gap-2">
          <button
            onClick={onPlayPause}
            className="p-1.5 sm:p-2 hover:bg-white/20 rounded-full transition"
            disabled={isLoading}
          >
            {isPlaying ? (
              <Pause className="w-5 h-5 sm:w-6 sm:h-6" />
            ) : (
              <Play className="w-5 h-5 sm:w-6 sm:h-6" />
            )}
          </button>

          <button
            onClick={onRefresh}
            className="p-1.5 sm:p-2 hover:bg-white/20 rounded-full transition"
            disabled={isLoading}
          >
            <RefreshCcw className="w-5 h-5 sm:w-6 sm:h-6" />
          </button>
        </div>

        <div className="flex items-center gap-2 sm:gap-4">
          <button
            onClick={onMuteToggle}
            className="p-1.5 sm:p-2 hover:bg-white/20 rounded-full transition"
            disabled={isLoading}
          >
            {isMuted ? (
              <VolumeX className="w-5 h-5 sm:w-6 sm:h-6" />
            ) : (
              <Volume2 className="w-5 h-5 sm:w-6 sm:h-6" />
            )}
          </button>
          
          <button
            onClick={onFullscreen}
            className="p-1.5 sm:p-2 hover:bg-white/20 rounded-full transition"
            disabled={isLoading}
          >
            <Maximize className="w-5 h-5 sm:w-6 sm:h-6" />
          </button>
        </div>
      </div>
    </div>
  );
};

export default VideoControls;